/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.dlic.rest.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.dlic.rest.api.AbstractApiAction;
import com.floragunn.searchguard.dlic.rest.api.Endpoint;
import com.floragunn.searchguard.dlic.rest.validation.AbstractConfigurationValidator;
import com.floragunn.searchguard.dlic.rest.validation.NoOpValidator;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class FlushCacheApiAction
extends AbstractApiAction {
    @Inject
    public FlushCacheApiAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository cl, StaticSgConfig staticSgConfig, ClusterService cs, PrincipalExtractor principalExtractor, AuthorizationService authorizationService, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ThreadPool threadPool, AuditLog auditLog) {
        super(settings, configPath, controller, client, adminDNs, cl, staticSgConfig, cs, principalExtractor, authorizationService, specialPrivilegesEvaluationContextProviderRegistry, threadPool, auditLog);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_searchguard/api/cache"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/api/cache"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_searchguard/api/cache"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/api/cache"));
    }

    @Override
    protected Endpoint getEndpoint() {
        return Endpoint.CACHE;
    }

    @Override
    protected void handleDelete(final RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0])), (ActionListener)new ActionListener<ConfigUpdateResponse>(){

            public void onResponse(ConfigUpdateResponse ur) {
                if (ur.hasFailures()) {
                    FlushCacheApiAction.this.log.error("Cannot flush cache due to", (Throwable)ur.failures().get(0));
                    FlushCacheApiAction.this.internalErrorResponse(channel, "Cannot flush cache due to " + ((FailedNodeException)ur.failures().get(0)).getMessage() + ".");
                    return;
                }
                FlushCacheApiAction.this.successResponse(channel, "Cache flushed successfully.");
                if (FlushCacheApiAction.this.log.isDebugEnabled()) {
                    FlushCacheApiAction.this.log.debug("cache flushed successfully");
                }
            }

            public void onFailure(Exception e) {
                FlushCacheApiAction.this.log.error("Cannot flush cache due to", (Throwable)e);
                FlushCacheApiAction.this.internalErrorResponse(channel, "Cannot flush cache due to " + e.getMessage() + ".");
            }
        });
    }

    @Override
    protected void handlePost(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.POST);
    }

    @Override
    protected void handleGet(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.GET);
    }

    @Override
    protected void handlePut(RestChannel channel, RestRequest request, Client client, DocNode content) throws IOException {
        this.notImplemented(channel, RestRequest.Method.PUT);
    }

    @Override
    protected AbstractConfigurationValidator getValidator(RestRequest request, BytesReference ref, Object ... param) {
        return new NoOpValidator(request, ref, this.settings, param);
    }

    @Override
    protected String getResourceName() {
        return null;
    }

    @Override
    protected CType<?> getConfigName() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }
}

